import {IResultAviaStation} from 'selectors/avia/utils/denormalization/station';

import {compareStrings} from '../comparators/compareStrings';
import {ESortDirection} from '../comparators/TComparator';

export function compareStations(
    stA: IResultAviaStation,
    stB: IResultAviaStation,
) {
    return compareStrings(
        stA.settlement ? stA.settlement.title : stA.title,
        stB.settlement ? stB.settlement.title : stB.title,
        ESortDirection.ASCENDING,
    );
}
