import {EAviaSearchTimeFilter} from 'reducers/avia/search/results/filters/reducer';

import * as Flags from 'utilities/flags/flags';

import {getTimeOfTheDay} from './getTimeOfTheDay';

export function checkTimeByFilter(
    localDataTimeStr: string,
    timeFilter: Flags.Flag<EAviaSearchTimeFilter>,
): boolean {
    if (!timeFilter) {
        return true;
    }

    const timePartOfThaDay = getTimeOfTheDay(localDataTimeStr);

    return Flags.isEnabled(timeFilter, timePartOfThaDay);
}
