import {IAviaSearchSegmentsAirportsFilter} from 'reducers/avia/search/results/filters/reducer';

import {TFilterConverter} from './index';

export const airportsFilterConverter: TFilterConverter<
    IAviaSearchSegmentsAirportsFilter[]
> = {
    fromString(str) {
        const segments = str.split('b');
        if (segments.length < 2) {
            return [];
        }
        const forward = segments[0].slice(1);
        const backward = segments[1];
        const forwardParts = forward.split('|');
        const backwardParts = backward.split('|');
        return [
            partsToAirportsFilter(forwardParts),
            partsToAirportsFilter(backwardParts),
        ];
    },
    toString(value) {
        const [forward, backward] = value;

        return `f${segmentToString(forward)}b${segmentToString(backward)}`;
    },
};

function splitPart(part: string | undefined) {
    return part ? part.split(',').map(Number).filter(Boolean) : [];
}

function partsToAirportsFilter(parts: string[]) {
    const [departure, arrival, transfers] = parts;
    return {
        departure: splitPart(departure),
        arrival: splitPart(arrival),
        transfers: splitPart(transfers),
    };
}

function segmentToString(
    segment: IAviaSearchSegmentsAirportsFilter | undefined,
) {
    if (!segment) {
        return '||';
    }
    return [
        segment.departure.join(','),
        segment.arrival.join(','),
        segment.transfers.join(','),
    ].join('|');
}
