import {TAviaSearchCompanyFilter} from 'reducers/avia/search/results/filters/reducer';

import {TFilterConverter} from './index';

export const companyFilterConverter: TFilterConverter<TAviaSearchCompanyFilter> =
    {
        fromString(str) {
            const [combination, ...companies] = str
                .split(',')
                .filter(Boolean)
                .map(Number)
                .filter(x => !isNaN(x));

            return {
                combinationsAreEnabled: Boolean(combination),
                companiesIds: companies,
            };
        },
        toString(value) {
            const dataToCompress = [
                Number(value.combinationsAreEnabled),
                ...value.companiesIds,
            ];

            return dataToCompress.join(',');
        },
    };
