import {IPriceFilter} from 'reducers/avia/search/results/filters/reducer';

import {CURRENCY_RUR} from 'utilities/currency/codes';

import {TFilterConverter} from './index';

export const priceFilterConverter: TFilterConverter<IPriceFilter> = {
    fromString(str) {
        const value = Number(str);
        if (isNaN(value) || value <= 0) {
            return {value: null};
        }
        return {value: {value, currency: CURRENCY_RUR}};
    },
    toString({value}) {
        return value ? String(value.value) : '';
    },
};
