import {HOUR} from 'utilities/dateUtils/constants';

import {
    IAviaSearchTransferFilter,
    EAviaSearchTransferFilter,
} from 'reducers/avia/search/results/filters/reducer';

import * as Flags from 'utilities/flags/flags';

import {TFilterConverter} from './index';

const {EXCLUDE_NIGHTLY, NO_AIRPORT_CHANGE, NO_TRANSFERS, ONE_CHANGE} =
    EAviaSearchTransferFilter;

export const transferFilterConverter: TFilterConverter<IAviaSearchTransferFilter> =
    {
        fromString(str) {
            const [
                noTransfersRaw,
                excludeNightlyRaw,
                oneChangeRaw,
                minRaw,
                maxRaw,
                noAirportChangeRaw,
            ] = str.split(',').map(Number);

            const noTransfers = Boolean(noTransfersRaw);
            const excludeNightly = Boolean(excludeNightlyRaw);
            const oneChange = Boolean(oneChangeRaw);
            const min = Math.round(Math.max(minRaw || 0, 0) * HOUR);
            const max = Math.round(Math.max(maxRaw || 0, 0) * HOUR);
            const noAirportChange = Boolean(noAirportChangeRaw);

            let times = 0 as Flags.Flag<EAviaSearchTransferFilter>;

            if (noTransfers) {
                times = Flags.enable(times, NO_TRANSFERS);
            }

            if (excludeNightly) {
                times = Flags.enable(times, EXCLUDE_NIGHTLY);
            }

            if (oneChange) {
                times = Flags.enable(times, ONE_CHANGE);
            }

            if (noAirportChange) {
                times = Flags.enable(times, NO_AIRPORT_CHANGE);
            }

            return {
                value: times,
                range: min === 0 && max === 0 ? null : [min, max],
            };
        },
        toString({value, range}) {
            const [min, max] = range || [0, 0];

            return [
                Number(Flags.isEnabled(value, NO_TRANSFERS)),
                Number(Flags.isEnabled(value, EXCLUDE_NIGHTLY)),
                Number(Flags.isEnabled(value, ONE_CHANGE)),
                min / HOUR,
                max / HOUR,
                Number(Flags.isEnabled(value, NO_AIRPORT_CHANGE)),
            ].join(',');
        },
    };
