import {TAviaSearchPartnersFilter} from 'reducers/avia/search/results/filters/reducer';

import {IResultAviaVariant} from 'selectors/avia/utils/denormalization/variant';

import {isPassingAirportsFilter} from 'projects/avia/lib/search/filters/isPassingAirportsFilter';
import {isPassingBaggageFilter} from 'projects/avia/lib/search/filters/isPassingBaggageFilter';
import {isPassingPlusPointsFilter} from 'projects/avia/lib/search/filters/isPassingPlusPointsFilter';
import {isPassingCompanyFilter} from 'projects/avia/lib/search/filters/isPassingCompanyFilter';
import {isPassingPriceFilter} from 'projects/avia/lib/search/filters/isPassingPriceFilter';
import {isPassingTimeFilters} from 'projects/avia/lib/search/filters/isPassingTimeFilters';
import {isPassingTransferFilters} from 'projects/avia/lib/search/filters/isPassingTransferFilters';

function getFiltered<V>(
    check: (variant: IResultAviaVariant, value: V) => boolean,
): (
    value: V,
    variants: IResultAviaVariant[],
) => Record<string, IResultAviaVariant> {
    return function (value, variants): Record<string, IResultAviaVariant> {
        const filtered: Record<string, IResultAviaVariant> = {};

        for (let i = 0; i < variants.length; i++) {
            const variant = variants[i];

            if (!check(variant, value)) {
                filtered[variant.tag] = variant;
            }
        }

        return filtered;
    };
}

function getFilteredWithData<V, D>(
    check: (variant: IResultAviaVariant, value: V, data: D) => boolean,
): (
    value: V,
    variants: IResultAviaVariant[],
    data: D,
) => Record<string, IResultAviaVariant> {
    return function (
        value,
        variants,
        data,
    ): Record<string, IResultAviaVariant> {
        const filtered: Record<string, IResultAviaVariant> = {};

        for (let i = 0; i < variants.length; i++) {
            const variant = variants[i];

            if (!check(variant, value, data)) {
                filtered[variant.tag] = variant;
            }
        }

        return filtered;
    };
}

export const aviaFilterBy = {
    airports: getFiltered(isPassingAirportsFilter),
    baggage: getFiltered(isPassingBaggageFilter),
    company: getFiltered(isPassingCompanyFilter),
    price: getFilteredWithData(isPassingPriceFilter),
    time: getFiltered(isPassingTimeFilters),
    transfer: getFiltered(isPassingTransferFilters),
    partner: getFiltered(
        (variant: IResultAviaVariant, filterValue: TAviaSearchPartnersFilter) =>
            filterValue.length === 0 ||
            filterValue.includes(variant.price.partner.code),
    ),
    plusPoints: getFiltered(isPassingPlusPointsFilter),
};
