import {isEqual} from 'lodash';

import {
    getInitialState,
    IAviaSearchResultsFilters,
} from 'reducers/avia/search/results/filters/reducer';

const INITIAL_FILTERS_VALUES = getInitialState();

export function getAppliedAviaFilters(
    filters: Partial<IAviaSearchResultsFilters>,
): Partial<IAviaSearchResultsFilters> {
    return Object.entries(filters)
        .filter(
            ([key, value]) =>
                !isEqual(
                    value,
                    INITIAL_FILTERS_VALUES[
                        key as keyof IAviaSearchResultsFilters
                    ],
                ),
        )
        .reduce(
            (res, [key, value]) => ({
                ...res,
                [key]: value,
            }),
            {},
        );
}
