import {EAviaSearchTimeFilter} from 'reducers/avia/search/results/filters/reducer';

export function getTimeOfTheDay(
    localDataTimeStr: string,
): EAviaSearchTimeFilter {
    const hours = Number(localDataTimeStr.slice(11, 13));

    if (hours < 6) return EAviaSearchTimeFilter.NIGHT;
    if (hours < 12) return EAviaSearchTimeFilter.MORNING;
    if (hours < 18) return EAviaSearchTimeFilter.DAY;

    return EAviaSearchTimeFilter.EVENING;
}
