import {first, last} from 'lodash';

import {IAviaSearchSegmentsAirportsFilter} from 'reducers/avia/search/results/filters/reducer';

import {IResultAviaVariant} from 'selectors/avia/utils/denormalization/variant';

export function isPassingAirportsFilter(
    variant: IResultAviaVariant,
    segmentFilters: IAviaSearchSegmentsAirportsFilter[],
): boolean {
    for (let i = 0; i < variant.route.length; i++) {
        const segment = variant.route[i];
        const segmentFilter = segmentFilters[i];

        if (!segment || !segmentFilter) {
            continue;
        }

        if (segmentFilter.departure.length) {
            const flight = first(segment);
            if (flight && !segmentFilter.departure.includes(flight.from.id)) {
                return false;
            }
        }

        if (segmentFilter.arrival.length) {
            const flight = last(segment);
            if (flight && !segmentFilter.arrival.includes(flight.to.id)) {
                return false;
            }
        }

        if (segmentFilter.transfers.length > 0) {
            for (let j = 1; j < segment.length; j++) {
                const flight = segment[j];
                if (!segmentFilter.transfers.includes(flight.from.id)) {
                    return false;
                }
            }
        }
    }

    return true;
}
