import {isNotNullable} from 'types/utilities';

import {IAviaSearchPlusPointsFilter} from 'reducers/avia/search/results/filters/reducer';

import {IResultAviaVariant} from 'selectors/avia/utils/denormalization/variant';

export function isPassingPlusPointsFilter(
    variant: IResultAviaVariant,
    plusPointsFilter: IAviaSearchPlusPointsFilter,
) {
    if (plusPointsFilter.enabled) {
        return isNotNullable(variant.price.plusPoints);
    }

    return true;
}
