import {IPriceFilter} from 'reducers/avia/search/results/filters/reducer';

import {IResultAviaVariant} from 'selectors/avia/utils/denormalization/variant';

import {PriceComparator} from 'utilities/currency/compare';

export function isPassingPriceFilter(
    variant: IResultAviaVariant,
    priceFilter: IPriceFilter,
    priceComparator: PriceComparator,
): boolean {
    if (!priceFilter.value) {
        return true;
    }

    return priceComparator.isLessOrEqual(
        variant.price.tariff,
        priceFilter.value,
    );
}
