import {last} from 'lodash';

import {IAviaSearchTimeFilter} from 'reducers/avia/search/results/filters/reducer';

import {IResultAviaVariant} from 'selectors/avia/utils/denormalization/variant';

import {isEnabled} from 'utilities/flags/flags';

export function isPassingTimeFilters(
    variant: IResultAviaVariant,
    timeFilters: IAviaSearchTimeFilter[],
): boolean {
    if (!timeFilters.length) {
        return true;
    }

    const route = variant.route.filter(segment => segment.length > 0);

    for (let i = 0; i < route.length; i++) {
        const segment = route[i];
        const segmentTimeFilters = timeFilters[i];
        if (!segmentTimeFilters) {
            return true;
        }

        const departureFlight = segment[0];
        const arrivalFlight = last(segment);

        if (!departureFlight || !arrivalFlight) {
            return false;
        }

        if (
            segmentTimeFilters.departure &&
            !isEnabled(
                segmentTimeFilters.departure,
                departureFlight.departureTimeOfDay,
            )
        ) {
            return false;
        }

        if (
            segmentTimeFilters.arrival &&
            !isEnabled(
                segmentTimeFilters.arrival,
                arrivalFlight.arrivalTimeOfDay,
            )
        ) {
            return false;
        }
    }
    return true;
}
