import {
    EAviaSearchTransferFilter,
    IAviaSearchTransferFilter,
} from 'reducers/avia/search/results/filters/reducer';

import {IResultAviaVariant} from 'selectors/avia/utils/denormalization/variant';

import * as Flags from 'utilities/flags/flags';
import {isNighttimeTransfer} from 'projects/avia/lib/isNighttimeTransfer';

const {EXCLUDE_NIGHTLY, NO_AIRPORT_CHANGE, NO_TRANSFERS, ONE_CHANGE} =
    EAviaSearchTransferFilter;

export function isPassingTransferFilters(
    variant: IResultAviaVariant,
    transferFilter: IAviaSearchTransferFilter,
): boolean {
    if (!transferFilter.value && !transferFilter.range) {
        return true;
    }

    for (const segment of variant.route) {
        // Если сегмент состоит из одного рейса, то пересадок нет
        if (segment.length <= 1) {
            continue;
        }

        if (Flags.isEnabled(transferFilter.value, NO_TRANSFERS)) {
            if (segment.length > 1) {
                return false;
            }
        }

        if (Flags.isEnabled(transferFilter.value, ONE_CHANGE)) {
            if (segment.length > 2) {
                return false;
            }
        }

        for (let i = 0; i < segment.length - 1; i++) {
            const arrivalFlight = segment[i];
            const departureFlight = segment[i + 1];

            if (Flags.isEnabled(transferFilter.value, NO_AIRPORT_CHANGE)) {
                if (arrivalFlight.to.id !== departureFlight.from.id) {
                    return false;
                }
            }

            if (Flags.isEnabled(transferFilter.value, EXCLUDE_NIGHTLY)) {
                const isNighttime = isNighttimeTransfer({
                    arrivalDate: arrivalFlight.arrival.local,
                    departureDate: departureFlight.departure.local,
                });
                if (isNighttime) {
                    return false;
                }
            }
            if (transferFilter.range) {
                const [minDuration, maxDuration] = transferFilter.range;
                const transferDuration =
                    departureFlight.departureTime - arrivalFlight.arrivalTime;
                if (
                    transferDuration < minDuration ||
                    transferDuration > maxDuration
                ) {
                    return false;
                }
            }
        }
    }

    return true;
}
