import {IResultAviaFlight} from 'selectors/avia/utils/denormalization/flight';

/**
 * Возвращает общее время в пути в рамках рейса в милисекундах
 *
 * @param {IResultAviaFlight} flight - моделька рейса из выдачи
 *
 * @returns {number}
 */
export function getAviaFlightDuration(flight: IResultAviaFlight): number {
    const {departureTime, arrivalTime} = flight;
    return arrivalTime - departureTime;
}
