import {first, last} from 'lodash';

import {TAviaSearchAirportsFilterKeys} from 'reducers/avia/search/results/filters/reducer';

import {IResultAviaVariant} from 'selectors/avia/utils/denormalization/variant';
import {IResultAviaStation} from 'selectors/avia/utils/denormalization/station';

export type SegmentStationsMaps = Record<
    TAviaSearchAirportsFilterKeys,
    Record<number, IResultAviaStation>
>;

export function getStationMaps(
    variants: IResultAviaVariant[],
): SegmentStationsMaps[] {
    const stations: SegmentStationsMaps[] = [];

    for (let variantIdx = 0; variantIdx < variants.length; variantIdx++) {
        const route = variants[variantIdx].route;
        for (let segmentIdx = 0; segmentIdx < route.length; segmentIdx++) {
            let segmentStation = stations[segmentIdx];
            if (!segmentStation) {
                segmentStation = stations[segmentIdx] = {
                    departure: {},
                    arrival: {},
                    transfers: {},
                };
            }
            const segment = route[segmentIdx];

            // Аэропорты вылета
            const fromFlight = first(segment);
            if (fromFlight) {
                segmentStation.departure[fromFlight.from.id] = fromFlight.from;
            }

            // Аэропорты прибытия
            const toFlight = last(segment);
            if (toFlight) {
                segmentStation.arrival[toFlight.to.id] = toFlight.to;
            }

            // Аэропорты пересадок
            for (let i = 1; i < segment.length; i++) {
                const flight = segment[i];
                segmentStation.transfers[flight.from.id] = flight.from;
            }
        }
    }
    return stations;
}
