import {first, last} from 'lodash';

import {IResultAviaFlight} from 'selectors/avia/utils/denormalization/flight';

/**
 * Возвращает общее время в пути в рамках всего варианта в милисекундах
 *
 * @param {IResultAviaFlight} route - моделька варианта из выдачи
 *
 * @returns {number}
 */
export function getVariantOverallDuration(
    route: IResultAviaFlight[][],
): number {
    let result = 0;
    for (const segment of route) {
        const firstFlight = first(segment);
        const lastFlight = last(segment);
        if (firstFlight && lastFlight) {
            result += lastFlight.arrivalTime - firstFlight.departureTime;
        }
    }
    return result;
}
