import {REQUIRED_AVIA_SEARCH_PARAMS_KEYS} from 'projects/avia/constants/queryParams';

import {IAviaParams} from 'server/services/AviaSearchService/types/IAviaParams';

export function isAviaSearchParams(query: unknown): query is IAviaParams {
    if (!query || typeof query !== 'object') {
        return false;
    }

    return REQUIRED_AVIA_SEARCH_PARAMS_KEYS.every(key =>
        Reflect.has(query, key),
    );
}
