import moment from 'moment-timezone';

import {isValidDate} from 'projects/avia/lib/date/isValidDate';
import {isAviaSearchParams} from 'projects/avia/lib/search/isAviaSearchParams';
import {isValidActualDate} from 'projects/avia/lib/date/isValidActualDate';

export function isValidAviaSearchParams(
    query: unknown,
    outdateIsValid: boolean = true,
): boolean {
    const dateChecker = outdateIsValid ? isValidDate : isValidActualDate;

    if (!isAviaSearchParams(query)) {
        return false;
    }

    if (!dateChecker(query.when)) {
        return false;
    }

    if (
        query.return_date &&
        (!dateChecker(query.return_date) ||
            moment(query.when).isAfter(query.return_date))
    ) {
        return false;
    }

    if (
        [query.adult_seats, query.children_seats, query.infant_seats].some(
            seat => isNaN(Number(seat)),
        )
    ) {
        return false;
    }

    if (query.fromId && query.toId && query.fromId === query.toId) {
        return false;
    }

    if (query.fromName && query.toName && query.fromName === query.toName) {
        return false;
    }

    return Boolean(query.fromId && query.toId);
}
