import {IResultAviaVariant} from 'selectors/avia/utils/denormalization/variant';

export enum EAviaOfferType {
    /** Чартер */
    charter = 'charter',
    /** Особые условия */
    special = 'special',
}

export function getAviaOfferType(
    variants: IResultAviaVariant[],
): EAviaOfferType | undefined {
    const someFlightsAreCharter = variants.some(({price}) => price.charter);
    const everyFlightIsCharter =
        someFlightsAreCharter && variants.every(({price}) => price.charter);

    if (!someFlightsAreCharter) {
        return undefined;
    }

    return everyFlightIsCharter
        ? EAviaOfferType.charter
        : EAviaOfferType.special;
}
