import moment from 'moment-timezone';

import {WHEN_SPECIAL_VALUE} from 'types/common/When';

import {ROBOT} from 'utilities/dateUtils/formats';
import {getNow} from 'utilities/dateUtils';

/**
 * Преобразует специальные значения (tomorrow, today) к форматированной дате вида YYYY-MM-DD
 * @param when - строка в формате YYYY-MM-DD или специальное значение
 */
export function parseAviaPeriod(when: WHEN_SPECIAL_VALUE | string): string {
    switch (when) {
        case WHEN_SPECIAL_VALUE.TODAY:
            return moment(getNow()).format(ROBOT);
        case WHEN_SPECIAL_VALUE.TOMORROW:
            return moment(getNow()).add(1, 'days').format(ROBOT);
        case WHEN_SPECIAL_VALUE.AFTER_TOMORROW:
            return moment(getNow()).add(2, 'days').format(ROBOT);
        case WHEN_SPECIAL_VALUE.NEXT_WEEK:
            return moment(getNow()).add(1, 'weeks').format(ROBOT);
        case WHEN_SPECIAL_VALUE.NEXT_MONTH:
            return moment(getNow()).add(1, 'months').format(ROBOT);
        default:
            return when;
    }
}
