import {pickBy} from 'lodash';

import {AVIA_PARAMS_KEYS} from 'projects/avia/constants/queryParams';

const SEARCH_PARAMS: Set<string> = new Set(AVIA_PARAMS_KEYS);

export function pickAviaSearchFormParams(query: unknown) {
    if (typeof query !== 'object' || !query) {
        return {};
    }

    return pickBy(query, (value, name) => SEARCH_PARAMS.has(name));
}
