import {TStationType} from 'server/api/AviaTicketDaemonApi/types/IAviaTDAnswer';

export function getTypeOfAviaSegment(
    typeFrom: TStationType,
    typeTo: TStationType,
) {
    // Считаем что тип транспорта соответствует типу станций
    if (typeFrom === typeTo) {
        return typeFrom;
    }

    // Если станции разных типов - откидываем тип транспорта "самолёт"
    // и берём оставшийся тип транспорта.
    // Возможен кейс когда сегмент крусирует между жд и автобусной станцией.
    // В этом случае однозначно определить не можем - отдаём тип соответствующий
    // станции отправления
    return [typeFrom, typeTo].filter(type => type !== 'plane').pop() || 'plane';
}
