import {
    DEFAULT_ADULTS_COUNT,
    DEFAULT_CHILDREN_COUNT,
    DEFAULT_INFANTS_COUNT,
} from 'constants/avia';

import {IAviaParams} from 'server/services/AviaSearchService/types/IAviaParams';

export function setDefaultsAviaSearchParams(
    params: Partial<IAviaParams>,
): Partial<IAviaParams> {
    if (!params.adult_seats) {
        params.adult_seats = `${DEFAULT_ADULTS_COUNT}`;
    }

    if (!params.children_seats) {
        params.children_seats = `${DEFAULT_CHILDREN_COUNT}`;
    }

    if (!params.infant_seats) {
        params.infant_seats = `${DEFAULT_INFANTS_COUNT}`;
    }

    return params;
}
