import {values} from 'lodash';

import {TAviaSearchAirportsFilterKeys} from 'reducers/avia/search/results/filters/reducer';

import {IResultAviaStation} from 'selectors/avia/utils/denormalization/station';

import {SegmentStationsMaps} from './getStationMaps';
import {compareStations} from './compareStations';

export type SegmentStations = Record<
    TAviaSearchAirportsFilterKeys,
    IResultAviaStation[]
>;

export function stationMapsToStations(
    stationMap: SegmentStationsMaps,
): SegmentStations {
    return {
        arrival: values(stationMap.arrival).sort(compareStations),
        departure: values(stationMap.departure).sort(compareStations),
        transfers: values(stationMap.transfers).sort(compareStations),
    };
}
