import {IAviaGetSearchToCountryPageApiParams} from 'server/api/AviaGatewayApi/types/IAviaGetSearchToCountryPageApiParams';

/**
 * Возвращает признак того, что данные a и b для запроса страницы поиска в
 * страну одни и те же
 */
export function isCompatibleRequestParams(
    a: IAviaGetSearchToCountryPageApiParams,
    b: IAviaGetSearchToCountryPageApiParams,
): boolean {
    return (
        a.from === b.from &&
        a.to === b.to &&
        a.dateForward === b.dateForward &&
        a.dateBackward === b.dateBackward &&
        a.klass === b.klass &&
        a.passengers.adults === b.passengers.adults &&
        a.passengers.children === b.passengers.children &&
        a.passengers.infants === b.passengers.infants
    );
}
