import {URLs} from 'constants/urls';
import {EProjectName} from 'constants/common';

import {IInternalUrlOptions} from 'utilities/url/types';

import {internalUrl} from 'utilities/url';

export default function getFlightPageUrl({
    iata,
    number,
    when,
    fromStationCode,
    options,
}: {
    iata: string;
    number: string;
    when?: string;
    fromStationCode?: string;
    options?: IInternalUrlOptions;
}): string {
    return internalUrl(
        `${URLs[EProjectName.AVIA]}/flights/${iata}-${number}`,
        {
            when,
            from: fromStationCode,
        },
        options,
    );
}
