import {URLs} from 'constants/urls';

import {TSettlementKey, TStationKey} from 'types/PointKey';
import {EAviaClassType} from 'types/avia/EAviaClassType';
import TDateRobot from 'types/common/date/TDateRobot';
import {IPassengers} from 'projects/avia/pages/AviaBooking/types/IPassengers';
import {IUtmQueryParams} from 'types/common/IQueryParams';

import {internalUrl} from 'utilities/url';
import {getOneWayParam} from 'projects/avia/lib/urls/getSearchUrl';

export interface IGetSearchToAnywhereUrl {
    fromKey: TSettlementKey | TStationKey;
    dateForward: TDateRobot;

    dateBackward?: TDateRobot;
    passengers?: IPassengers;
    klass?: EAviaClassType;
    utm?: IUtmQueryParams;
}

/**
 * Возвращает урл страницы поиска в страну
 */
export function getSearchToAnywhereUrl({
    fromKey,
    dateForward,
    dateBackward,
    passengers,
    klass,
    utm,
}: IGetSearchToAnywhereUrl): string {
    const query = {
        ...utm,
        adult_seats: passengers?.adults,
        children_seats: passengers?.children,
        infant_seats: passengers?.infants,
        when: dateForward,
        return_date: dateBackward,
        oneway: getOneWayParam(dateBackward),
        klass,
    };

    return internalUrl(`${URLs.aviaSearchToAnywhereRoot}/${fromKey}/`, query);
}
