import {ParsedQuery} from 'query-string';

import {IPassengers} from 'projects/avia/pages/AviaBooking/types/IPassengers';
import {EAviaClassType} from 'types/avia/EAviaClassType';
import TDateRobot from 'types/common/date/TDateRobot';

import getValueFromEnum from 'utilities/getValueFromEnum';
import isDateRobot from 'utilities/dateUtils/isDateRobot';

export interface IParsedSearchParametersFromQuery {
    passengers: IPassengers;
    klass: EAviaClassType;

    dateForward?: TDateRobot;
    dateBackward?: TDateRobot;
}

export function parseSearchParametersFromQuery(
    query: ParsedQuery,
): IParsedSearchParametersFromQuery {
    /* eslint-disable camelcase */
    const {
        adult_seats,
        children_seats,
        infant_seats,
        klass: klassFromProps,
        return_date,
        when,
    } = query;

    let adultSeats =
        (typeof adult_seats === 'string' && parseInt(adult_seats, 10)) || 0;
    const childrenSeats =
        (typeof children_seats === 'string' && parseInt(children_seats, 10)) ||
        0;
    const infantSeats =
        (typeof infant_seats === 'string' && parseInt(infant_seats, 10)) || 0;

    if (adultSeats + childrenSeats + infantSeats === 0) {
        adultSeats = 1;
    }

    const klass =
        (typeof klassFromProps === 'string' &&
            getValueFromEnum(klassFromProps, EAviaClassType)) ||
        EAviaClassType.ECONOMY;
    const dateForward =
        typeof when === 'string' && isDateRobot(when) ? when : undefined;
    const dateBackward =
        typeof return_date === 'string' && isDateRobot(return_date)
            ? return_date
            : undefined;
    /* eslint-enable camelcase */

    return {
        passengers: {
            adults: adultSeats,
            children: childrenSeats,
            infants: infantSeats,
        },
        klass,
        dateForward,
        dateBackward,
    };
}
