import React from 'react';
import {Route, Switch} from 'react-router-dom';

import {EProjectName} from 'constants/common';
import {URLs} from 'constants/urls';

import {EFooterProject} from 'components/Footer/types';

import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {useAviaPortal} from 'utilities/hooks/useAviaPortal';
import {loadable} from 'utilities/pageLoadable';
import {useExperiments} from 'utilities/hooks/useExperiments';

import LayoutDefault from 'components/Layouts/LayoutDefault/LayoutDefault';
import NotFoundFragment from 'components/NotFound/NotFoundFragment/NotFoundFragment';

import {usePlatform} from 'contexts/PlatformContext';

import AviaBookingCreateOrder from '../AviaBookingCreateOrder/AviaBookingCreateOrder';
import {BookingPaymentContainer} from '../AviaBookingPayment/BookingPaymentContainer';
import {AviaBookingPaymentRedirectTarget} from '../AviaBookingPaymentRedirectTarget/AviaBookingPaymentRedirectTarget';
import AviaHappyPageContainer from '../AviaHappyPage/AviaHappyPageContainer';

const FinishPaymentPage = loadable(
    () => import('components/Layouts/PaymentFinish/PaymentFinish'),
);

const RoutesWithLayout: React.FC = () => {
    const deviceType = useDeviceType();
    const isAviaPortal = useAviaPortal();
    const {aviaNewTrustForm} = useExperiments();
    const {isTravelApp} = usePlatform();

    return (
        <LayoutDefault
            project={EProjectName.AVIA}
            footerType={EFooterProject.AVIA}
            showNavigation={deviceType.isDesktop && !isAviaPortal}
            hasSideSheetNavigation={!isAviaPortal}
            showHeader={!isTravelApp}
            showFooter={!isTravelApp}
        >
            <Switch>
                <Route
                    path={URLs.aviaBooking}
                    exact
                    component={AviaBookingCreateOrder}
                />

                {!aviaNewTrustForm && (
                    <Route
                        path={URLs.aviaBookingPayment}
                        exact
                        component={BookingPaymentContainer}
                    />
                )}

                <Route component={NotFoundFragment} />
            </Switch>
        </LayoutDefault>
    );
};

const AviaBooking: React.FC = () => {
    const {aviaNewTrustForm} = useExperiments();

    return (
        <Switch>
            {/*
             * Этот роут не должен быть обёрнут в Layout. Switch отрендерит либо
             * этот роут, либо следующий, который матчится на все урлы.
             */}
            {/*Страница редиректа для 3ds аэрофлота*/}
            <Route
                path={URLs.aviaBookingPaymentRedirectTarget}
                component={AviaBookingPaymentRedirectTarget}
            />

            {/*Страница редиректа для траста*/}
            <Route
                path={URLs.aviaBookingFinishPayment}
                component={FinishPaymentPage}
            />

            <Route
                path={URLs.aviaBookingResult}
                exact
                component={AviaHappyPageContainer}
            />

            {aviaNewTrustForm && (
                <Route
                    path={URLs.aviaBookingPayment}
                    exact
                    component={BookingPaymentContainer}
                />
            )}
            <Route component={RoutesWithLayout} />
        </Switch>
    );
};

export default AviaBooking;
