import {isNetworkError, isRetryableError} from 'axios-retry';

import {IBookingVariantsModelType} from 'server/services/AviaBookingService/variants/types';
import {ICompositeOrderStateDTO} from 'server/api/AviaBookingApi/types/ICompositeOrderStateDTO';
import {IOrderStateDTO} from 'server/api/AviaBookingApi/types/IOrderStateDTO';
import {IBookingCreateOrderRequest} from '../types/IBookingCreateOrder';
import {IConfirmationCompleteApiRequest} from 'server/api/AviaBookingApi/types/IConfirmationCompleteApiRequest';
import IAviaTestContextTokenServiceParams from 'server/services/TestContextService/types/IAviaTestContextTokenServiceParams';
import IAviaTestContextTokenServiceResponse from 'server/services/TestContextService/types/IAviaTestContextTokenServiceResponse';
import EGenericOrderSource from 'server/api/GenericOrderApi/types/common/EGenericOrderSource';
import {IOrderDTO} from 'server/api/AviaBookingApi/types/IOrderDTO';

import {BaseAviaApiClient} from 'projects/avia/lib/providers/BaseAviaApiClient';

import {EBookingServiceDeviceType} from 'server/api/AviaBookingApi/enums/EBookingServiceDeviceType';
import {IAviaBookingOrderPageData} from 'server/services/AviaBookingService/order/IAviaBookingOrderPageData';

interface IInitPaymentAsyncParameters {
    orderId: string;
    deviceType: EBookingServiceDeviceType;
    confirmationRedirectUrl: string;
    paymentRedirectUrl: string;
}

/** @deprecated */
class BookingApiClient extends BaseAviaApiClient {
    variants = (token: string): Promise<IBookingVariantsModelType> => {
        return this.get<IBookingVariantsModelType>(`/booking/variants`, {
            params: {token},
        });
    };

    createOrder = (data: IBookingCreateOrderRequest): Promise<IOrderDTO> => {
        return this.post('/booking/create-order', data);
    };

    getOrder = (
        orderId: string,
        source: EGenericOrderSource,
    ): Promise<IAviaBookingOrderPageData> => {
        return this.get<IAviaBookingOrderPageData>('/booking/orders', {
            params: {orderId, source},
        });
    };

    getState = (orderId: string): Promise<IOrderStateDTO> => {
        return this.get<IOrderStateDTO>('/booking/state', {
            params: {orderId},
        });
    };

    getCompositeState = (orderId: string): Promise<ICompositeOrderStateDTO> => {
        return this.get<ICompositeOrderStateDTO>('/booking/composite-state', {
            params: {orderId},
        });
    };

    initPayment = (
        orderId: string,
        redirectUrl: string,
    ): Promise<{redirectUrl: string}> => {
        return this.post<{redirectUrl: string}>(
            '/booking/payments',
            {redirectUrl},
            {params: {orderId}},
        );
    };

    initPaymentAsync = ({
        orderId,
        deviceType,
        confirmationRedirectUrl,
        paymentRedirectUrl,
    }: IInitPaymentAsyncParameters): Promise<void> => {
        return this.post<void>(
            '/booking/payments-async',
            {confirmationRedirectUrl, paymentRedirectUrl, deviceType},
            {params: {orderId}},
        );
    };

    confirmationComplete = (
        data: IConfirmationCompleteApiRequest,
    ): Promise<void> => {
        return this.post<void>('/booking/confirmation-complete', data, {
            axiosRetry: {
                retries: 2,
                retryCondition: (error): boolean =>
                    isNetworkError(error) || isRetryableError(error),
            },
        });
    };

    getTestContextToken = (
        params: IAviaTestContextTokenServiceParams,
    ): Promise<IAviaTestContextTokenServiceResponse> => {
        return this.get<IAviaTestContextTokenServiceResponse>(
            '/booking/testContext',
            {
                params,
            },
        );
    };
}

/** @deprecated */
export const bookingApiClient = new BookingApiClient();
