import React from 'react';

import {ICountry} from 'types/common/ICountry';
import {IPassengerWithDocumentsDTO} from 'server/api/TravelersApi/types/IPassengerDTO';
import {FlightType} from '../../types/FlightType';
import {EAviaLoyaltyCardType} from 'types/avia/book/EAviaLoyaltyCardType';
import {EAgeCategory} from '../../types/AgeCategoryType';

import {IWithQaAttributes} from 'utilities/qaAttributes/qaAttributes';
import {useDeviceType} from 'utilities/hooks/useDeviceType';

import AviaBookingFormDesktop from './components/AviaBookingFormDesktop/AviaBookingFormDesktop';
import AviaBookingFormMobile from './components/AviaBookingFormMobile/AviaBookingFormMobile';

export interface IAviaBookingFormProps extends IWithQaAttributes {
    countries: ICountry[];
    disabled?: boolean;
    flightType: FlightType;
    allowedLoyaltyPrograms: EAviaLoyaltyCardType[];
    types: EAgeCategory[];
    passengersGroupedByType: Partial<
        Record<EAgeCategory, IPassengerWithDocumentsDTO[]>
    >;
}

const AviaBookingForm: React.FC<IAviaBookingFormProps> = props => {
    const {isMobile} = useDeviceType();
    const Component = isMobile ? AviaBookingFormMobile : AviaBookingFormDesktop;

    return <Component {...props} />;
};

export default AviaBookingForm;
