import {useMemo} from 'react';
import {useFormState} from 'react-final-form';

import {
    IBookingFormData,
    IBookingFormErrors,
} from 'projects/avia/pages/AviaBooking/types/IBookingFormData';

export function useToggleHandler(
    isExpanded: boolean,
    toggle: () => void,
): (() => void) | undefined {
    const formState = useFormState<IBookingFormData>({
        subscription: {errors: true},
    });

    const isNumberError = useMemo(() => {
        const errors: IBookingFormErrors | undefined = formState.errors;
        const passengers = errors?.passengers;

        if (!passengers) {
            return false;
        }

        return passengers.some(passenger => passenger?.loyaltyCard?.number);
    }, [formState.errors]);

    return isNumberError && isExpanded ? undefined : toggle;
}
