import {FunctionComponent} from 'react';

import {IWithClassName} from 'types/withClassName';

import * as i18nBlock from 'i18n/components-BookingPassengerForm';

import TextWithIcon from 'components/TextWithIcon/TextWithIcon';
import AutoHeightAnimateControl from 'components/AutoHeightAnimateControl/AutoHeightAnimateControl';
import WarningFilledIcon from 'icons/16/WarningFilled';

import cx from './TextMessage.scss';

interface ITextMessageProps extends IWithClassName {
    isVisible: boolean;
    onClick?: () => void;
}

const TextMessage: FunctionComponent<ITextMessageProps> = ({
    className,
    onClick,
    isVisible,
}) => (
    <AutoHeightAnimateControl canShowComponent={isVisible}>
        <TextWithIcon
            className={className}
            size="m"
            text={i18nBlock.translatedMessage()}
            iconLeft={WarningFilledIcon}
            iconLeftClassName={cx('icon')}
            onClick={onClick}
        />
    </AutoHeightAnimateControl>
);

export default TextMessage;
