import {EAgeCategory} from 'projects/avia/pages/AviaBooking/types/AgeCategoryType';

type TTypesCounter = Record<EAgeCategory, number>;

export const getAviaPassengerTypesCounter = () => {
    const counter: TTypesCounter = {
        [EAgeCategory.adult]: 0,
        [EAgeCategory.child]: 0,
        [EAgeCategory.infant]: 0,
    };

    return (type: keyof TTypesCounter): number => {
        const count = counter[type];

        counter[type]++;

        return count;
    };
};
