import {IAutoCompleteDocument} from 'components/BookingPassengerForm/types/IDocument';

function isDocumentTranslated(document: IAutoCompleteDocument): boolean {
    const {
        isTranslatedFirstName,
        isTranslatedLastName,
        isTranslatedPatronymicName,
    } = document.meta;

    return (
        isTranslatedFirstName ||
        isTranslatedLastName ||
        isTranslatedPatronymicName
    );
}

export default isDocumentTranslated;
