import memoize from 'lodash/memoize';

import {EAgeCategory} from '../../../types/AgeCategoryType';
import {IPassengers} from '../../../types/IPassengers';

export const mapPassengersToTypes = memoize(
    (passengers: IPassengers): EAgeCategory[] => [
        ...Array(passengers.adults).fill('adult'),
        ...Array(passengers.children).fill('child'),
        ...Array(passengers.infants).fill('infant'),
    ],
    ({adults, children, infants}: IPassengers) =>
        `${adults}.${children}.${infants}`,
);
