import {useMobile} from 'utilities/hooks/useMobile';

import Box, {IBoxProps, TBoxSizes} from 'components/Box/Box';

interface BookingCardContentProps extends IBoxProps {}

function usePaddings(): {x: TBoxSizes; y: TBoxSizes} {
    const isMobile = useMobile();

    if (isMobile) {
        return {x: 3, y: 4};
    }

    return {x: 8, y: 5};
}

export function BookingCardContent(props: BookingCardContentProps) {
    return <Box {...usePaddings()} {...props} />;
}
