import {EAppActions} from 'constants/platforms/TPlatforms';

import {IBookingVariantsModelType} from 'server/services/AviaBookingService/variants/types';

import {aviaURLs} from 'projects/avia/lib/urls';

import * as i18nBlock from 'i18n/avia-AviaBooking-error-modals';

import {ICoordinator} from 'contexts/PlatformContext';

import IModalErrorConfig from './IModalErrorConfig';

export default function getFatalConfig({
    variants,
    isTravelApp,
    coordinator,
}: {
    variants: IBookingVariantsModelType;
    isTravelApp: boolean;
    coordinator: ICoordinator;
}): IModalErrorConfig {
    return {
        title: i18nBlock.fatalDashTitle(),
        content: i18nBlock.fatalDashDescription(),
        primaryAction: isTravelApp
            ? {
                  type: 'button',
                  title: i18nBlock.fatalDashButtonDashBack(),
                  handler(): void {
                      coordinator.doAction(
                          EAppActions.NAVIGATE_TO_SEARCH_AVIA_PAGE,
                      );
                  },
              }
            : {
                  type: 'button-link',
                  title: i18nBlock.fatalDashButtonDashBack(),
                  props: {
                      to: aviaURLs.getSearchResultsUrlByQid(variants.qid),
                  },
              },
    };
}
