import {IBookingVariantsModelType} from 'server/services/AviaBookingService/variants/types';

import IPrice from 'utilities/currency/PriceInterface';

import {ICoordinator} from 'contexts/PlatformContext';

import {EBookingModalErrorType} from '../BookingErrorModal';
import getPriceChangeConfig from './getPriceChangeConfig';
import getTariffNotAvailableConfig from './getTariffNotAvailableConfig';
import getSameNameRestritionConfig from './getSameNameRestritionConfig';
import getUnknownConfig from './getUnknownConfig';
import getFatalConfig from './getFatalConfig';
import IModalErrorConfig from './IModalErrorConfig';

export default function getModalConfig({
    variantToken,
    errorType,
    variants,
    newPrice,
    onClose,
    isMobile,
    isTravelApp,
    coordinator,
}: {
    variantToken: string;
    errorType: EBookingModalErrorType;
    variants: IBookingVariantsModelType;
    newPrice?: IPrice | null;
    onClose?: () => void;
    isMobile: boolean;
    isTravelApp: boolean;
    coordinator: ICoordinator;
}): IModalErrorConfig {
    switch (errorType) {
        case EBookingModalErrorType.PriceChanged:
            return getPriceChangeConfig({
                variantToken,
                variants,
                newPrice,
                isTravelApp,
                coordinator,
                onClose,
            });
        case EBookingModalErrorType.TariffNotAvailable:
            return getTariffNotAvailableConfig({
                variants,
                isTravelApp,
                coordinator,
                onClose,
            });
        case EBookingModalErrorType.Unknown:
            return getUnknownConfig({
                variants,
                isMobile,
                isTravelApp,
                coordinator,
            });
        case EBookingModalErrorType.SameNameRestriction:
            return getSameNameRestritionConfig({onClose});
        default:
            return getFatalConfig({variants, isTravelApp, coordinator});
    }
}
