import * as i18nBlock from 'i18n/avia-AviaBooking-error-modals';

import IModalErrorConfig from './IModalErrorConfig';

export default function getSameNameRestritionConfig({
    onClose,
}: {
    onClose?: () => void;
}): IModalErrorConfig {
    return {
        title: i18nBlock.sameDashNameDashTitle(),
        content: i18nBlock.sameDashNameDashDescription(),
        primaryAction: {
            type: 'button',
            title: i18nBlock.sameDashNameDashButtonDashContinue(),
            handler: onClose,
        },
    };
}
