import {EAppActions} from 'constants/platforms/TPlatforms';

import {IBookingVariantsModelType} from 'server/services/AviaBookingService/variants/types';

import {aviaURLs} from 'projects/avia/lib/urls';

import * as i18nBlock from 'i18n/avia-AviaBooking-error-modals';

import {ICoordinator} from 'contexts/PlatformContext';

import IModalErrorConfig from './IModalErrorConfig';

export default function getTariffNotAvailableConfig({
    variants,
    onClose,
    isTravelApp,
    coordinator,
}: {
    variants: IBookingVariantsModelType;
    isTravelApp: boolean;
    coordinator: ICoordinator;
    onClose?: () => void;
}): IModalErrorConfig {
    return {
        title: i18nBlock.tariffDashNotDashAvailableDashTitle(),
        content: i18nBlock.tariffDashNotDashAvailableDashDescription(),
        primaryAction: {
            type: 'button',
            title: i18nBlock.tariffDashNotDashAvailableDashButtonDashContinue(),
            handler: onClose,
        },
        secondaryAction: isTravelApp
            ? {
                  type: 'button',
                  title: i18nBlock.tariffDashNotDashAvailableDashButtonDashBack(),
                  handler(): void {
                      coordinator.doAction(
                          EAppActions.NAVIGATE_TO_SEARCH_AVIA_PAGE,
                      );
                  },
              }
            : {
                  type: 'button-link',
                  title: i18nBlock.tariffDashNotDashAvailableDashButtonDashBack(),
                  props: {
                      to: aviaURLs.getSearchResultsUrlByQid(variants.qid),
                  },
              },
    };
}
