import {EAppActions} from 'constants/platforms/TPlatforms';

import {IBookingVariantsModelType} from 'server/services/AviaBookingService/variants/types';

import {aviaURLs} from 'projects/avia/lib/urls';

import * as i18nBlock from 'i18n/avia-AviaBooking-error-modals';

import {ICoordinator} from 'contexts/PlatformContext';

import IModalErrorConfig from './IModalErrorConfig';

export default function getUnknownConfig({
    variants,
    isMobile,
    isTravelApp,
    coordinator,
}: {
    variants: IBookingVariantsModelType;
    isMobile: boolean;
    isTravelApp: boolean;
    coordinator: ICoordinator;
}): IModalErrorConfig {
    const primaryActionTitle = isMobile
        ? i18nBlock.shortDashUnknownDashButtonDashContinue()
        : i18nBlock.unknownDashButtonDashContinue();

    return {
        title: i18nBlock.unknownDashTitle(),
        content: i18nBlock.unknownDashDescription(),
        primaryAction: isTravelApp
            ? {
                  type: 'button',
                  title: primaryActionTitle,
                  handler(): void {
                      coordinator.doAction(
                          EAppActions.NAVIGATE_TO_EXTERNAL_URL,
                          variants.orderUrl,
                      );
                  },
              }
            : {
                  type: 'button-link',
                  title: primaryActionTitle,
                  props: {
                      url: variants.orderUrl,
                  },
              },
        secondaryAction: isTravelApp
            ? {
                  type: 'button',
                  title: i18nBlock.unknownDashButtonDashBack(),
                  handler(): void {
                      coordinator.doAction(
                          EAppActions.NAVIGATE_TO_SEARCH_AVIA_PAGE,
                      );
                  },
              }
            : {
                  type: 'button-link',
                  title: i18nBlock.unknownDashButtonDashBack(),
                  props: {
                      to: aviaURLs.getSearchResultsUrlByQid(variants.qid),
                  },
              },
    };
}
