import {ClassOfService} from 'server/api/AviaBookingApi/enums/classOfService';
import {TermAvailability} from 'server/api/AviaBookingApi/types/TermAvailability';
import {IBookingFlightModel} from 'server/services/AviaBookingService/variants/types';
import {CurrencyType} from 'utilities/currency/CurrencyType';

export const FLIGHT: IBookingFlightModel = {
    id: 'SEG_SVOSVX_1',
    flightNumber: '1410',
    departureAirport: {
        id: 9600213,
        code: 'SVO',
        title: 'Шереметьево',
        ttype: 'plane',
        phraseIn: 'Шереметьево',
        phraseTo: 'Шереметьево',
        phraseFrom: 'Шереметьева',
        settlement: 213,
        timeZoneCode: 'Europe/Moscow',
        timeZoneOffset: 180,
    },
    arrivalAirport: {
        id: 9600370,
        code: 'SVX',
        title: 'Кольцово123',
        ttype: 'plane',
        phraseIn: 'Кольцово123',
        phraseTo: 'Кольцово',
        phraseFrom: 'Кольцово',
        settlement: 54,
        timeZoneCode: 'Asia/Yekaterinburg',
        timeZoneOffset: 300,
    },
    departureSettlement: {
        id: 213,
        title: 'Москва',
        phraseIn: 'Москве',
        phraseTo: 'Москву',
        countryId: 225,
        phraseFrom: 'Москвы',
    },
    arrivalSettlement: {
        id: 54,
        title: 'Екатеринбург',
        phraseIn: 'Екатеринбурге',
        phraseTo: 'Екатеринбург',
        countryId: 225,
        phraseFrom: 'Екатеринбурга',
    },
    departureDate: '2019-05-29T06:45:00',
    arrivalDate: '2019-05-29T11:10:00',
    company: {
        id: 26,
        url: 'http://www.aeroflot.ru/',
        color: '#004993',
        title: 'Аэрофлот',
        logoSvg:
            'https://avatars.mds.yandex.net/get-avia/365172/2a0000015a80533a1069fe5b31973630e037/svg',
        alliance: null,
        iataCode: 'SU',
        sirenaCode: 'СУ',
    },
    operatingCompany: {
        id: 26,
        url: 'http://www.aeroflot.ru/',
        color: '#004993',
        title: 'Аэрофлот',
        logoSvg:
            'https://avatars.mds.yandex.net/get-avia/365172/2a0000015a80533a1069fe5b31973630e037/svg',
        alliance: null,
        iataCode: 'SU',
        sirenaCode: 'СУ',
    },
    fareTerms: {
        terms: {
            miles: {
                miles: '75%',
                availability: TermAvailability.FREE,
                charge: {
                    currency: CurrencyType.RUB,
                    value: 1000,
                },
                places: 1,
                weight: 1000,
                size: 'SIZE',
                specialNotes: [],
            },
            baggage: {
                size: '158',
                places: 1,
                weight: 23,
                specialNotes: [
                    'Габариты одного места не более 158 см по сумме 3-х измерений',
                    'Участникам программы «Аэрофлот Бонус» Платинового, Золотого и Серебряного уровней и программ поощрения часто летающих пассажиров альянса Sky Team уровней Elite и Elite Plus на всех направлениях дополнительно предоставляется к норме норме бесплатного провоза багажа: 2 места для участников программы «Аэрофлот Бонус» Платинового уровня; 1 место для участников программы «Аэрофлот Бонус» Золотого и Серебряного уровней; 1 место для участников уровней Elite и Elite Plus программ поощрения часто летающих пассажиров альянса SkyTeam.',
                    'Перевозки экипажей морских судов: 2 места',
                ],
                availability: TermAvailability.FREE,
                charge: {
                    currency: CurrencyType.RUB,
                    value: 1000,
                },
                miles: 'miles',
            },
            carryOn: {
                size: '55x40x25',
                places: 1,
                weight: 10,
                specialNotes: [
                    'Габариты одного места ручной клади не должны превышать: 55 см в длину, 40 см в ширину, 25 см в высоту',
                ],
                availability: TermAvailability.FREE,
                charge: {
                    currency: CurrencyType.RUB,
                    value: 1000,
                },
                miles: 'miles',
            },
            refundable: {
                availability: TermAvailability.NOT_AVAILABLE,
                charge: {
                    currency: CurrencyType.RUB,
                    value: 1000,
                },
                miles: 'miles',
                places: 1,
                weight: 1000,
                size: 'SIZE',
                specialNotes: [],
            },
            disclosureUrl: {
                availability: TermAvailability.NOT_AVAILABLE,
                charge: {
                    currency: CurrencyType.RUB,
                    value: 1000,
                },
                miles: 'miles',
                places: 1,
                weight: 1000,
                size: 'SIZE',
                specialNotes: [
                    'https://www.aeroflot.ru/ru-ru/information/purchase/rate/fare_rules',
                ],
            },
            openReturnDate: {
                availability: TermAvailability.NOT_AVAILABLE,
                charge: {
                    currency: CurrencyType.RUB,
                    value: 1000,
                },
                miles: 'miles',
                places: 1,
                weight: 1000,
                size: 'SIZE',
                specialNotes: [
                    'https://www.aeroflot.ru/ru-ru/information/purchase/rate/fare_rules',
                ],
            },
            changingCarriage: {
                charge: {
                    value: 2300,
                    currency: CurrencyType.RUB,
                },
                availability: TermAvailability.CHARGE,
                specialNotes: ['За транзакцию'],
                miles: 'miles',
                places: 1,
                weight: 1000,
                size: 'SIZE',
            },
            refundableNoShow: {
                availability: TermAvailability.NOT_AVAILABLE,
                miles: 'miles',
                places: 1,
                weight: 1000,
                size: 'SIZE',
                charge: {
                    value: 2300,
                    currency: CurrencyType.RUB,
                },
                specialNotes: [],
            },
            changingCarriageNoShow: {
                availability: TermAvailability.NOT_AVAILABLE,
                miles: 'miles',
                places: 1,
                weight: 1000,
                size: 'SIZE',
                charge: {
                    value: 2300,
                    currency: CurrencyType.RUB,
                },
                specialNotes: [],
            },
        },
        baseClass: ClassOfService.ECONOMY,
        tariffGroupName: 'БЮДЖЕТ',
    },
};
