import React from 'react';

import {IAirlineReferenceDTO} from 'server/api/AviaBookingApi/types/IAirlineReferenceDTO';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';
import {useMobile} from 'utilities/hooks/useMobile';

import AirlineLogo from 'projects/avia/components/AirlineLogo/AirlineLogo';

import cx from './AirlineTitle.scss';

interface IAirlineTitleProps extends IWithQaAttributes {
    flightNumber: string;
    company: IAirlineReferenceDTO;
    operatingCompany: IAirlineReferenceDTO;
}

const AirlineTitle: React.FC<IAirlineTitleProps> = props => {
    const isMobile = useMobile();
    const {
        company,
        company: {iataCode},
        operatingCompany,
        flightNumber,
    } = props;

    const {title, logoSvg} =
        operatingCompany?.id !== company?.id ? operatingCompany : company;
    const fullFlightNumber = `${iataCode} ${Number(flightNumber)}`;

    return (
        <div className={cx('row', {isMobile})}>
            <AirlineLogo
                logoSrc={logoSvg}
                airlineTitle={title}
                size={isMobile ? 's' : 'm'}
            />

            <div className={cx('title')}>
                {title}
                &nbsp; {isMobile && <>&nbsp;</>}
                <span
                    className={cx('number')}
                    {...prepareQaAttributes({
                        parent: props,
                        current: 'flightNumber',
                    })}
                >
                    {fullFlightNumber}
                </span>
            </div>
        </div>
    );
};

export default AirlineTitle;
