import React, {useCallback} from 'react';
import {useDispatch} from 'react-redux';

import {ISegmentFare} from 'server/api/AviaBookingApi/types/ISegmentFare';

import {openTariffsModal} from 'reducers/avia/booking/tariffsModalIsOpened/actions';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import * as i18nBlock from 'i18n/avia-AviaBooking-BookingFlightInfo';

import LinkButton from 'components/LinkButton/LinkButton';

interface IFareTermsButtonProps extends ISegmentFare, IWithQaAttributes {
    fareModalBackText?: string;
}

const FareTermsButton: React.FC<IFareTermsButtonProps> = props => {
    const dispatch = useDispatch();

    const tariffName = i18nBlock.tariffDashName({
        tariff: props.tariffGroupName,
    });

    const handleClick = useCallback((): void => {
        dispatch(openTariffsModal());
    }, [dispatch]);

    return (
        <LinkButton
            theme="normal"
            onClick={handleClick}
            {...prepareQaAttributes(props)}
        >
            {tariffName}
        </LinkButton>
    );
};

export default FareTermsButton;
