import React from 'react';

import {IPassengerExperience} from 'projects/avia/types/IPassengerExperience';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import {
    localizeSeatsInRow,
    localizeSeatsTotal,
} from 'projects/avia/components/PassengerExperience/PassengerExperience';
import Intersperse from 'components/Intersperse/Intersperse';

interface IPassengerExperienceFormatterProps
    extends IPassengerExperience,
        IWithQaAttributes {}

const PassengerExperienceFormatter: React.FC<IPassengerExperienceFormatterProps> =
    props => {
        const strings = [
            <span
                key="planeModel"
                {...prepareQaAttributes({
                    parent: props,
                    current: 'planeModel',
                })}
            >
                {props.planeModel}
            </span>,
            props.seatsInRow && localizeSeatsInRow(props.seatsInRow),
            props.seatsTotal && localizeSeatsTotal(props.seatsTotal),
        ].filter(Boolean);

        return <Intersperse separator={', '}>{strings}</Intersperse>;
    };

export default PassengerExperienceFormatter;
