import React from 'react';

import DeviceTypeContext from 'contexts/DeviceTypeContext';

import cx from './BookingLayout.scss';

export const Container: React.FC = ({children}) => (
    <DeviceTypeContext.Consumer>
        {({isMobile}) => (
            <div className={cx('container', isMobile && 'container_mobile')}>
                {children}
            </div>
        )}
    </DeviceTypeContext.Consumer>
);
