import React from 'react';

import {ITravelerNotebook} from 'projects/avia/pages/AviaBooking/types/ITravelerNotebook';

export const BookingTravelersNotebookContext = React.createContext<
    ITravelerNotebook | null | undefined
>(null);

interface BookingTravelersNotebookConsumerProps {
    children(travelerNotebook: ITravelerNotebook): React.ReactNode;
}

export const BookingTravelersNotebookConsumer: React.FC<BookingTravelersNotebookConsumerProps> =
    props => (
        <BookingTravelersNotebookContext.Consumer>
            {travelerNotebook =>
                travelerNotebook && props.children(travelerNotebook)
            }
        </BookingTravelersNotebookContext.Consumer>
    );
