import {IWithClassName} from 'types/withClassName';

import * as localized from 'i18n/avia-AviaBooking-BookingTrustLikeSpinner';

import Spinner from 'components/Spinner/Spinner';

import cx from './BookingTrustLikeSpinner.scss';

export function BookingTrustLikeSpinner({className}: IWithClassName) {
    return (
        <div className={cx('wrapper', className)}>
            <Spinner size="xxl" />
            <div className={cx('text')}>{localized.waitDashMessage()}</div>
        </div>
    );
}
